<?php
include 'db.php'; // Include your database connection file

// Start the session
session_start();

// Get user ID from the session
$user_id = $_SESSION['user_id'] ?? null;

// Check if user_id is valid
if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit;
}

// Prepare response array
$response = [
    "status" => "error",
    "message" => "No invoices found"
];

// Query the `invoice` table to get all invoices for the user
$invoice_query = "
    SELECT * FROM invoice 
    WHERE user_id = '$user_id' AND Delete_status = 0
    ORDER BY Created_date DESC
";

$invoice_result = mysqli_query($conn, $invoice_query);

if ($invoice_result && mysqli_num_rows($invoice_result) > 0) {
    $invoices = [];

    while ($invoice = mysqli_fetch_assoc($invoice_result)) {
        $invoice_id = $invoice['invoice_id'];

        // Fetch invoice data for this invoice
        $invoice_data_query = "
            SELECT * FROM invoice_data
            WHERE invoice_id = '$invoice_id' AND Delete_status = 0
        ";

        $invoice_data_result = mysqli_query($conn, $invoice_data_query);
        $invoice_data = [];

        if ($invoice_data_result && mysqli_num_rows($invoice_data_result) > 0) {
            while ($data = mysqli_fetch_assoc($invoice_data_result)) {
                $invoice_data[] = $data;
            }
        }

        // Add invoice data to the current invoice
        $invoice['invoice_data'] = $invoice_data;

        // Append to the list of invoices
        $invoices[] = $invoice;
    }

    // Return success and the list of invoices
    $response['status'] = "success";
    $response['message'] = "Invoices fetched successfully";
    $response['data'] = $invoices;
} else {
    $response['message'] = "No invoices found for this user";
}

// Return the response as JSON
echo json_encode($response);
?>
